extends CanvasLayer


# nodes  
onready var globalGame  = get_tree().get_current_scene() #Global Game Node

onready var animation : AnimationPlayer = $AnimationPlayer
onready var progress_bar : ProgressBar = $layout/lvl_progress/bar
onready var tween : Tween = $Tween
onready var tutorial_panel : Panel = $layout/tap_to_jump/background
onready var hand_tap_panel : CenterContainer = $layout/tap_to_play_anim

onready var level = get_parent()
onready var lvl_stairs_nmbr : int

var tutorial : bool = true

func _ready():
	
	yield(level,"ready") # Wait for parent to complete stairs generation 
	lvl_stairs_nmbr = level.get_stair_count() #so we can count stairs number
	if B4DFramework.get_level() > 1: #show only for first lvl
		tutorial_panel.visible = false
		hand_tap_panel.rect_position.y = 1650
		

	globalGame.connect("on_step",self,"change_progress")
	globalGame.connect("on_boost",self,"progress_on_boost")
	init_progress()


##return the progress value per step
func get_progress_per_step() -> int :
	return 100 / lvl_stairs_nmbr

##Set the maxmimum/value of progress bar 
func init_progress() -> void:
	var progress_per_step = get_progress_per_step()
	progress_bar.max_value = (progress_per_step * lvl_stairs_nmbr) - progress_per_step

func change_progress(value : int  = 0) -> void :
	var current_progress : int = progress_bar.value
	
	var next_progress : int
	
	if value > 0 :
		next_progress = value * get_progress_per_step()
	else :
		next_progress = current_progress + get_progress_per_step()
	
	tween.interpolate_property(progress_bar,
	"value",
	current_progress,
	next_progress,
	0.2)
	tween.start()

func progress_on_boost(stair_position : Vector3):
	yield(get_tree().create_timer(0.6),"timeout")
	change_progress(-stair_position.z) 

func _unhandled_input(event):
	if event is InputEventScreenTouch and event.is_pressed():
		if tutorial:
			tutorial = false
			animation.play("tap_to_play_disappear")

